/*
 * Decompiled with CFR 0.152.
 */
package net.sixik.sdmshoprework.api.shop;

import dev.architectury.platform.Platform;
import dev.ftb.mods.ftblibrary.config.ConfigGroup;
import dev.ftb.mods.ftblibrary.config.ConfigValue;
import dev.ftb.mods.ftblibrary.config.StringConfig;
import dev.ftb.mods.ftblibrary.icon.Icon;
import dev.ftb.mods.ftblibrary.icon.ItemIcon;
import dev.ftb.mods.ftblibrary.util.TooltipList;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Objects;
import java.util.UUID;
import net.minecraft.nbt.CompoundTag;
import net.minecraft.nbt.ListTag;
import net.minecraft.nbt.StringTag;
import net.minecraft.nbt.Tag;
import net.minecraft.network.chat.Component;
import net.minecraft.world.item.Item;
import net.minecraft.world.item.ItemStack;
import net.minecraft.world.item.Items;
import net.sixik.sdmshoprework.SDMShopR;
import net.sixik.sdmshoprework.api.IConstructor;
import net.sixik.sdmshoprework.api.INBTSerializable;
import net.sixik.sdmshoprework.api.register.ShopContentRegister;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntry;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryCondition;
import net.sixik.sdmshoprework.api.shop.AbstractShopEntryLimiter;
import net.sixik.sdmshoprework.common.integration.FTBQuests.ConfigIconItemStack;
import net.sixik.sdmshoprework.common.register.CustomIconItem;
import net.sixik.sdmshoprework.common.register.ItemsRegister;
import net.sixik.sdmshoprework.common.shop.ShopBase;
import net.sixik.sdmshoprework.common.shop.ShopEntry;
import net.sixik.sdmshoprework.common.utils.NBTUtils;

public abstract class AbstractShopTab
implements INBTSerializable<CompoundTag> {
    public UUID shopTabUUID;
    private ShopBase shop;
    public Component title = Component.m_237119_();
    public ItemStack icon = Items.f_42127_.m_7968_();
    private final List<AbstractShopEntry> tabEntry = new ArrayList<AbstractShopEntry>();
    private final List<AbstractShopEntryLimiter> tabEntryLimits = new ArrayList<AbstractShopEntryLimiter>();
    private final List<AbstractShopEntryCondition> tabConditions = new ArrayList<AbstractShopEntryCondition>();
    public List<String> descriptionList = new ArrayList<String>();

    public AbstractShopTab(ShopBase shop) {
        this.shop = shop;
        this.shopTabUUID = UUID.randomUUID();
        for (IConstructor<AbstractShopEntryCondition> value : ShopContentRegister.SHOP_ENTRY_CONDITIONS.values()) {
            AbstractShopEntryCondition condition = value.createDefaultInstance();
            if (!Platform.isModLoaded((String)condition.getModId())) continue;
            this.tabConditions.add(condition);
        }
    }

    public ShopBase getShop() {
        return this.shop;
    }

    public List<AbstractShopEntryLimiter> getTabEntryLimits() {
        return this.tabEntryLimits;
    }

    public List<AbstractShopEntryCondition> getTabConditions() {
        return this.tabConditions;
    }

    public List<AbstractShopEntry> getTabEntry() {
        return this.tabEntry;
    }

    public boolean removeEntry(UUID uuid) {
        Iterator<AbstractShopEntry> it = this.getTabEntry().iterator();
        while (it.hasNext()) {
            AbstractShopEntry entry = it.next();
            if (!entry.entryUUID.equals(uuid)) continue;
            it.remove();
            return true;
        }
        return false;
    }

    public AbstractShopEntry getShopEntry(UUID uuid) {
        for (AbstractShopEntry shopEntry : this.tabEntry) {
            if (!Objects.equals(shopEntry.entryUUID, uuid)) continue;
            return shopEntry;
        }
        return null;
    }

    public void getConfig(ConfigGroup config) {
        TooltipList list = new TooltipList();
        list.add((Component)Component.m_237115_((String)"sdmr.shop.tab.title.info"));
        config.addString("title", this.title.getString(), v -> {
            this.title = Component.m_237115_((String)v);
        }, "");
        config.add("icon", (ConfigValue)new ConfigIconItemStack(), (Object)this.icon, v -> {
            this.icon = v;
        }, (Object)Items.f_42127_.m_7968_());
        config.addList("description", this.descriptionList, (ConfigValue)new StringConfig(null), (Object)"");
        ConfigGroup group = config.getGroup("dependencies");
        for (AbstractShopEntryCondition tabCondition : this.tabConditions) {
            tabCondition.getConfig(group);
        }
    }

    public int getIndex() {
        return this.shop.getShopTabs().indexOf(this);
    }

    public Icon getIcon() {
        if (this.icon.m_150930_((Item)ItemsRegister.CUSTOM_ICON.get())) {
            return CustomIconItem.getIcon(this.icon);
        }
        return ItemIcon.getItemIcon((ItemStack)this.icon);
    }

    @Override
    public CompoundTag serializeNBT() {
        CompoundTag nbt = new CompoundTag();
        NBTUtils.putItemStack(nbt, "icon", this.icon);
        nbt.m_128362_("shopTabUUID", this.shopTabUUID);
        nbt.m_128359_("title", this.title.getString());
        ListTag tagTabEntries = new ListTag();
        for (AbstractShopEntry abstractShopEntry : this.tabEntry) {
            tagTabEntries.add((Object)abstractShopEntry.serializeNBT());
        }
        nbt.m_128365_("tabEntry", (Tag)tagTabEntries);
        ListTag tagTabEntryLimits = new ListTag();
        for (AbstractShopEntryLimiter abstractShopEntryLimiter : this.tabEntryLimits) {
            tagTabEntryLimits.add((Object)abstractShopEntryLimiter.serializeNBT());
        }
        nbt.m_128365_("tabLimit", (Tag)tagTabEntryLimits);
        ListTag listTag = new ListTag();
        for (AbstractShopEntryCondition tabCondition : this.tabConditions) {
            listTag.add((Object)tabCondition.serializeNBT());
        }
        nbt.m_128365_("tabCondition", (Tag)listTag);
        ListTag listTag2 = new ListTag();
        for (String s : this.descriptionList) {
            listTag2.add((Object)StringTag.m_129297_((String)s));
        }
        nbt.m_128365_("description", (Tag)listTag2);
        return nbt;
    }

    @Override
    public void deserializeNBT(CompoundTag nbt) {
        this.shopTabUUID = nbt.m_128342_("shopTabUUID");
        this.title = Component.m_237115_((String)nbt.m_128461_("title"));
        this.icon = NBTUtils.getItemStack(nbt, "icon");
        ListTag tagTabEntryLimits = nbt.m_128437_("tabLimit", 10);
        this.tabEntryLimits.clear();
        for (int i = 0; i < tagTabEntryLimits.size(); ++i) {
            this.tabEntryLimits.add(AbstractShopEntryLimiter.from(tagTabEntryLimits.m_128728_(i)));
        }
        ListTag tagTabConditions = nbt.m_128437_("tabCondition", 10);
        this.tabConditions.clear();
        for (int i = 0; i < tagTabConditions.size(); ++i) {
            this.tabConditions.add(AbstractShopEntryCondition.from(tagTabConditions.m_128728_(i)));
        }
        ListTag tagEntries = nbt.m_128437_("tabEntry", 10);
        this.tabEntry.clear();
        for (Tag tagEntry : tagEntries) {
            ShopEntry shopEntry = new ShopEntry(this);
            shopEntry.deserializeNBT((CompoundTag)tagEntry);
            this.tabEntry.add(shopEntry);
        }
        this.descriptionList.clear();
        ListTag tagDescription = nbt.m_128437_("description", 8);
        for (Tag tag : tagDescription) {
            this.descriptionList.add(tag.m_7916_());
        }
    }

    public boolean isLocked() {
        if (SDMShopR.isEditMode()) {
            return false;
        }
        for (AbstractShopEntryCondition tabCondition : this.tabConditions) {
            if (!tabCondition.isLocked()) continue;
            return true;
        }
        return false;
    }
}

